<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\DeploymentBundle\LogTaggingProcessor;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->parameters()
        ->set('cyber.deployment.log.tags', []);

    $container->services()
        ->set('cyber_deployment.log_tagging_processor', LogTaggingProcessor::class)
            ->args([
                param('cyber.deployment.log.tags'),
            ])
            ->tag('monolog.processor', ['method' => 'processRecord'])
        ->alias(LogTaggingProcessor::class, 'cyber_deployment.log_tagging_processor');
    // @formatter:on
};
