<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Symfony\Component\DependencyInjection\Loader\Configurator;

use Cyber\DeploymentBundle\Configuration;
use Cyber\DeploymentBundle\Fixtures\FixtureEventProducer;

return static function (ContainerConfigurator $container) {
    // @formatter:off
    $container->parameters()
    ;

    $container->services()
        ->set('cyber_deployment.config', Configuration::class)
            // method calls added via extension
        ->alias(Configuration::class, 'cyber_deployment.config')

        ->set('cyber_deployment.fixtures.event_producer', FixtureEventProducer::class)
            ->args([
                service('event_dispatcher'),
            ])
    ;
    // @formatter:on
};
