<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\DeploymentBundle\Fixtures;

use Cyber\DeploymentBundle\Event\BeforeFixturesAppliedEvent;
use Cyber\DeploymentBundle\Event\FixturesAppliedEvent;
use Cyber\DeploymentBundle\Event\PostDatabaseResetEvent;
use Cyber\DeploymentBundle\Event\PreDatabaseResetEvent;
use Psr\EventDispatcher\EventDispatcherInterface;

class FixtureEventProducer
{
    public function __construct(private EventDispatcherInterface $dispatcher)
    {
    }

    /**
     * @param string[] $groups
     */
    public function beforeFixtures(array $groups): BeforeFixturesAppliedEvent
    {
        /** @var BeforeFixturesAppliedEvent */
        return $this->dispatcher->dispatch(new BeforeFixturesAppliedEvent($groups));
    }

    /**
     * @param string[] $groups
     */
    public function afterFixtures(array $groups): FixturesAppliedEvent
    {
        /** @var FixturesAppliedEvent */
        return $this->dispatcher->dispatch(new FixturesAppliedEvent($groups));
    }

    public function beforeDbReset(string $name): PreDatabaseResetEvent
    {
        $event = new PreDatabaseResetEvent($name);
        $this->dispatcher->dispatch($event);

        return $event;
    }

    public function afterDbReset(string $name): PostDatabaseResetEvent
    {
        $event = new PostDatabaseResetEvent($name);
        $this->dispatcher->dispatch($event);

        return $event;
    }
}
