<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\FormExtrasBundle;

/**
 * Class USStateList.
 *
 * @SuppressWarnings(PHPMD.BooleanArgumentFlag)
 */
class USStateList
{
    const STATES = [
        'AL' => 'Alabama',
        'AK' => 'Alaska',
        'AZ' => 'Arizona',
        'AR' => 'Arkansas',
        'CA' => 'California',
        'CO' => 'Colorado',
        'CT' => 'Connecticut',
        'DE' => 'Delaware',
        'DC' => 'District of Columbia',
        'FL' => 'Florida',
        'GA' => 'Georgia',
        'HI' => 'Hawaii',
        'ID' => 'Idaho',
        'IL' => 'Illinois',
        'IN' => 'Indiana',
        'IA' => 'Iowa',
        'KS' => 'Kansas',
        'KY' => 'Kentucky',
        'LA' => 'Louisiana',
        'ME' => 'Maine',
        'MD' => 'Maryland',
        'MA' => 'Massachusetts',
        'MI' => 'Michigan',
        'MN' => 'Minnesota',
        'MS' => 'Mississippi',
        'MO' => 'Missouri',
        'MT' => 'Montana',
        'NE' => 'Nebraska',
        'NV' => 'Nevada',
        'NH' => 'New Hampshire',
        'NJ' => 'New Jersey',
        'NM' => 'New Mexico',
        'NY' => 'New York',
        'NC' => 'North Carolina',
        'ND' => 'North Dakota',
        'OH' => 'Ohio',
        'OK' => 'Oklahoma',
        'OR' => 'Oregon',
        'PA' => 'Pennsylvania',
        'RI' => 'Rhode Island',
        'SC' => 'South Carolina',
        'SD' => 'South Dakota',
        'TN' => 'Tennessee',
        'TX' => 'Texas',
        'UT' => 'Utah',
        'VT' => 'Vermont',
        'VA' => 'Virginia',
        'WA' => 'Washington',
        'WV' => 'West Virginia',
        'WI' => 'Wisconsin',
        'WY' => 'Wyoming',
        'PR' => 'Puerto Rico',
        'VI' => 'Virgin Islands',
    ];

    /** @var null|array<string,string> */
    private static $flipped;

    /**
     * @param bool $flipped
     *
     * @return array<string,string>
     */
    public static function getStates($flipped = false): array
    {
        if ($flipped) {
            if (null === self::$flipped) {
                self::$flipped = \array_flip(self::STATES);
            }

            return self::$flipped;
        }

        return self::STATES;
    }

    public static function getName(string $state): ?string
    {
        if (!self::isValid($state)) {
            return null;
        }

        return self::STATES[$state];
    }

    /**
     * @return string[]
     */
    public static function getAbbreviations(): array
    {
        return \array_keys(self::STATES);
    }

    public static function isValid(string $state): bool
    {
        return isset(self::STATES[$state]);
    }
}
