<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\FormExtrasBundle;

use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormInterface;

/**
 * Use this in your FOSRestControllers to standardize error checks and responses.
 */
trait ControllerFormsTrait
{
    private function checkForm(FormInterface $form): bool
    {
        if (!$form->isSubmitted()) {
            // if not submitted attempts to submit with empty data to generate whole form validation errors
            $form->submit([]);
            $form->addError(new FormError('Not Submitted'));

            return false;
        }

        return $form->isValid();
    }

    /**
     * @param FormInterface $form
     *
     * @return mixed
     */
    private function createFormErrorResponse(FormInterface $form)
    {
        return ['form' => $form];
    }
}
