<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\FormExtrasBundle\Form\Type;

use Cyber\FormExtrasBundle\Form\Type\StateType;
use Symfony\Component\Form\Test\TypeTestCase;

/**
 * @internal
 *
 * @coversNothing
 */
class StateTypeTest extends TypeTestCase
{
    /**
     * @dataProvider buildFormDataProvider
     *
     * @param mixed $short
     * @param mixed $long
     * @param mixed $label
     */
    public function testBuildForm($short, $long, $label): void
    {
        $view = $this->factory
            ->create(StateType::class, null, ['short_name' => $short, 'long_name' => $long])->createView();

        static::assertEquals($label, $view->vars['choices'][0]->label);
    }

    /**
     * @return array<array<mixed>>
     */
    public function buildFormDataProvider(): array
    {
        return [
            [true, true, 'AL - Alabama'],
            [true, false, 'AL'],
            [false, true, 'Alabama'],
        ];
    }
}
