# About Extension
The default entity type expects ID of the entity being passed into the form field which would then be transformed to
actual entity object by the Type. 

This extension augments this behavior by allowing to bass an object with an `id` property (name configurable) into
form field. 

This is espeically useful when working with JSON API where you need to fetch objects and then pass selected options
back to another API's entity field. Basically instead of having to perform mapping and extracting IDs you can simply
pass the object you got from first API as a whole to the second API.

```
let items = itemApi.getItems();

orderApi.postOrder({ someProps, items: items});
// instead of
orderApi.postOrder({ someProps, items: items.map(item => item.id)})
```

# How to Activate

The extension is deactivated by default for backward compatibility. You can activate it through bundle configuration:

```yaml
# config/packages/cyber_form_extras.yaml
cyber_form_extras:
    entity_type_extension: true # Set to true to enable the extension
```

If you need to manually register the extension as a service (not recommended), you can do so with:

```yaml
services:
    Cyber\FormExtrasBundle\Form\Extension\EntityTypeExtension:
        tags:
            - form.type_extension
```

# Nelmio Documentation
If 'documentation' option is provided wthin forms (typically by Nelmio API Doc bundle), it will be populated by
appropriate OpenApi style documentation.
