<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\FormExtrasBundle;

use Cyber\FormExtrasBundle\Form\Extension\EntityTypeExtension;
use Cyber\FormExtrasBundle\Form\Type\StateType;
use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader\Configurator\ContainerConfigurator;

use function Symfony\Component\DependencyInjection\Loader\Configurator\param;

use Symfony\Component\HttpKernel\Bundle\AbstractBundle;

class CyberFormExtrasBundle extends AbstractBundle
{
    public function configure(DefinitionConfigurator $definition): void
    {
        // @formatter:off
        $definition->rootNode()
            ->children()
                ->booleanNode('entity_type_extension')
                    ->defaultFalse()
                    ->info('Enable the EntityTypeExtension that allows passing objects with ID property to entity fields')
                ->end()
                ->booleanNode('state_type')
                    ->defaultTrue()
                    ->info('Enable the StateType form type for US state selection')
                ->end()
            ->end();
        // @formatter:on
    }

    /**
     * @param array{entity_type_extension?: bool, state_type?: bool} $config
     *
     * @inheritDoc
     */
    public function loadExtension(array $config, ContainerConfigurator $container, ContainerBuilder $builder): void
    {
        // Set configuration parameters
        $services = $container->services();

        if ($config['entity_type_extension'] ?? false) {
            $services->set('cyber_form_extras.form.extension.entity_type', EntityTypeExtension::class)
                ->tag('form.type_extension')
                ->alias(EntityTypeExtension::class, 'cyber_form_extras.form.extension.entity_type');
        }

        // Conditionally register the StateType
        if ($config['state_type'] ?? true) {
            $services->set('cyber_form_extras.form.type.state', StateType::class)
                ->tag('form.type')
                ->alias(StateType::class, 'cyber_form_extras.form.type.state');
        }
    }
}
