<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\FormExtrasBundle;

use Cyber\FormExtrasBundle\CyberFormExtrasBundle;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBag;

/**
 * @internal
 *
 * @covers \Cyber\FormExtrasBundle\CyberFormExtrasBundle
 */
class CyberFormExtrasBundleTest extends TestCase
{
    public function testEmptyConfigs(): void
    {
        $bundle    = new CyberFormExtrasBundle();
        $extension = $bundle->getContainerExtension();
        $container = new ContainerBuilder(new ParameterBag([
            'kernel.environment' => 'test',
            'kernel.build_dir'   => __DIR__,
            'kernel.debug'       => true,
        ]));

        $config = [];

        static::assertNotNull($extension, 'Extension should not be null');
        $extension->load([$config], $container);

        static::assertTrue($container->hasDefinition('cyber_form_extras.form.type.state'));
    }

    public function testEntityTypeExtensionEnabledRegistersService(): void
    {
        $bundle    = new CyberFormExtrasBundle();
        $extension = $bundle->getContainerExtension();
        $container = new ContainerBuilder(new ParameterBag([
            'kernel.environment' => 'test',
            'kernel.build_dir'   => __DIR__,
            'kernel.debug'       => true,
        ]));

        $config = [
            'entity_type_extension' => true,
            'state_type'            => true,
        ];

        static::assertNotNull($extension, 'Extension should not be null');
        $extension->load([$config], $container);

        static::assertTrue($container->hasDefinition('cyber_form_extras.form.extension.entity_type'));
    }

    public function testEntityTypeExtensionDisabledDoesNotRegisterService(): void
    {
        $bundle    = new CyberFormExtrasBundle();
        $extension = $bundle->getContainerExtension();
        $container = new ContainerBuilder(new ParameterBag([
            'kernel.environment' => 'test',
            'kernel.build_dir'   => __DIR__,
            'kernel.debug'       => true,
        ]));

        $config = [
            'entity_type_extension' => false,
            'state_type'            => true,
        ];

        static::assertNotNull($extension, 'Extension should not be null');
        $extension->load([$config], $container);

        static::assertFalse($container->hasDefinition('cyber_form_extras.form.extension.entity_type'));
    }

    public function testStateTypeEnabledRegistersService(): void
    {
        $bundle    = new CyberFormExtrasBundle();
        $extension = $bundle->getContainerExtension();
        $container = new ContainerBuilder(new ParameterBag([
            'kernel.environment' => 'test',
            'kernel.build_dir'   => __DIR__,
            'kernel.debug'       => true,
        ]));

        $config = [
            'entity_type_extension' => false,
            'state_type'            => true,
        ];

        static::assertNotNull($extension, 'Extension should not be null');
        $extension->load([$config], $container);

        static::assertTrue($container->hasDefinition('cyber_form_extras.form.type.state'));
    }

    public function testStateTypeDisabledDoesNotRegisterService(): void
    {
        $bundle    = new CyberFormExtrasBundle();
        $extension = $bundle->getContainerExtension();
        $container = new ContainerBuilder(new ParameterBag([
            'kernel.environment' => 'test',
            'kernel.build_dir'   => __DIR__,
            'kernel.debug'       => true,
        ]));

        $config = [
            'entity_type_extension' => false,
            'state_type'            => false,
        ];

        static::assertNotNull($extension, 'Extension should not be null');
        $extension->load([$config], $container);

        static::assertFalse($container->hasDefinition('cyber_form_extras.form.type.state'));
    }
}
