# State List

This bundle provides a list of US States accessible via simple static call to `USStateList::getStates()`

Class `USStateList` provides other, less frequently used functions related to state list.

## Use In Asserts
You can easily use this class in asserts for validation:

```php
<?php 

/**
* @Assert\Choice(callback={USStateList::class, "getAbbreviations"}, message="Invalid State")
*/
private $state;
```

# State Form Type

This bundle provides a form type `StateType` which is a standard choice selection for US States. You can configure the
labels to be 2 letter abbreviations, or full state name, or both, using simple options.

## How to Activate

The StateType is activated by default when you register the bundle in your application. You can control this behavior through bundle configuration:

```yaml
# config/packages/cyber_form_extras.yaml
cyber_form_extras:
    state_type: true # Set to false to disable the StateType
```

## Options

### short_name
> *boolean* default `true`

If set to true the choice label will contain 2 letter abbreviation.

### long_name
> *boolean* default `false`

If set to true the choice label will contain full state name.

### separator
> *string* default ` - `

If both `short_name` and `long_name` options are set to **true** then this value is used to separate 2 letter
abbreviation from the full state name in the choice label.
