<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

$bundlePath = __DIR__ . '/..';
$absolute   = \realpath($bundlePath) . '/';

echo 'Enter bundle name (ex. CyberCron): ';
$bundleName = \trim(\fgets(STDIN) ?: '');

if (!\preg_match('#^([A-Z][a-z]+)(([A-Z][a-z]+)+?)(Bundle){0,1}$#', $bundleName, $matches)) {
    echo 'Invalid bundle name, should be [organization prefix][bundle name] (ex. AcmeCron)';
    exit(1);
}

echo 'Enter description for bundle: ';
$description = \trim(\fgets(STDIN) ?: '');

echo 'Enter your name: ';
$authorName = \trim(\fgets(STDIN) ?: '');

echo 'Enter your email: ';
$authorEmail = \trim(\fgets(STDIN) ?: '');

[, $orgPrefix, $bundleName] = $matches;

$orgLower    = \mb_strtolower($orgPrefix);
$bundleLower = \mb_strtolower($bundleName);
$bundleFull  = $orgPrefix . \ucfirst($bundleName);

$replaceSrc = [
    '#Cyber#',
    '#cyber#',
    '#Skeleton#',
    '#skeleton#',
    '#\[description\]#',
    '#\[author-name\]#',
    '#author@email\.com#',
];

$replaceWith = [
    $orgPrefix,
    $orgLower,
    $bundleName,
    $bundleLower,
    $description,
    $authorName,
    $authorEmail,
];

echo \sprintf('Will configure "%sBundle" inside "%s". Continue (y/n)?', $bundleFull, $absolute);
$confirm = \trim(\fgets(STDIN) ?: '');

if ('y' !== \mb_strtolower($confirm)) {
    echo 'Aborting!' . PHP_EOL;
    exit(1);
}

$files = [
    'src/DependencyInjection/CyberSkeletonExtension.php',
    'src/DependencyInjection/Configuration.php',
    'config/services.yaml',
    'src/CyberSkeletonBundle.php',
    'tests/DependencyInjection/CyberSkeletonExtensionTest.php',
    'composer.json',
    'phpunit.xml.dist',
];

foreach ($files as $file) {
    $fullPath = $absolute . $file;

    if (!\file_exists($fullPath)) {
        echo 'File not found: ' . $fullPath . PHP_EOL;
        continue;
    }

    if (false === $contents = \file_get_contents($fullPath)) {
        throw new RuntimeException('Could not read content of file: ' . $fullPath);
    }
    \unlink($fullPath);

    $newPath = $absolute . \preg_replace($replaceSrc, $replaceWith, $file);
    \file_put_contents($newPath, \preg_replace($replaceSrc, $replaceWith, $contents));
}
