<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\IdpBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * @inheritDoc
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_idp');

        /** @var ArrayNodeDefinition|NodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        //@formatter:off
        $rootNode->children()
            ->arrayNode('saml')
                ->children()
                    ->scalarNode('entity_id')
                        ->isRequired()
                        ->info('ID your app will identify itself with. Usually URL to metadata endpoint')
                    ->end()
                    ->scalarNode('sp_repository_service')
                        ->isRequired()
                        ->info('Service for looking up registered SPs must implement \Cyber\IdpBundle\Entity\ServiceProviderRepoInterface')
                    ->end()
                    ->scalarNode('certificate')
                        ->isRequired()
                        ->info('Certificate used for signing SAML Assertions')
                    ->end()
                    ->scalarNode('key')
                        ->isRequired()
                        ->info('Private key for signing SAML Assertions')
                    ->end()
                ->end()
            ->end()
        ->end();
        //@formatter:on

        return $treeBuilder;
    }
}
