<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\IdpBundle\DependencyInjection;

use Cyber\IdpBundle\Service\SamlConfig;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class CyberIdpExtension extends Extension
{
    /**
     * @inheritDoc
     */
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config        = $this->processConfiguration($configuration, $configs);

        if (isset($config['saml'])) {
            $this->addSamlConfiguration($container, $config['saml']);
        }
    }

    /**
     * @param ContainerBuilder                                                                          $container
     * @param array{entity_id: string, sp_repository_service: string, certificate: string, key: string} $saml
     */
    private function addSamlConfiguration(ContainerBuilder $container, mixed $saml): void
    {
        $container->register(SamlConfig::class)
            ->setArguments([
                '$entityId'    => $saml['entity_id'],
                '$spRepo'      => new Reference($saml['sp_repository_service']),
                '$certificate' => $saml['certificate'],
                '$key'         => $saml['key'],
            ]);
    }
}
