<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\IdpBundle\Entity;

use Cyber\IdpBundle\Service\AssertionProviderInterface;

interface ServiceProviderRepoInterface
{
    /**
     * @param string $entityId the SP entity ID
     *
     * @return null|ServiceProvider provider corresponding to id, null if not found
     */
    public function findByEntityId(string $entityId): ?ServiceProvider;

    /**
     * @param ServiceProvider $serviceProvider SP requesting authentication
     *
     * @return AssertionProviderInterface to provide response assertions
     */
    public function getAssertionProvider(ServiceProvider $serviceProvider): AssertionProviderInterface;
}
