<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\IdpBundle\Event;

use Cyber\IdpBundle\Entity\ServiceProvider;
use LightSaml\Model\Assertion\Assertion;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event is dispatched before response is signed.
 *
 * Allows you to alter the assertion before it gets signed.
 *
 * @see FinalizeResponseEvent
 */
class FinalizeAssertionsEvent extends Event
{
    public function __construct(public readonly Assertion $assertion, public readonly ServiceProvider $svProvider)
    {
    }
}
