<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\IdpBundle\Event;

use Cyber\IdpBundle\Entity\ServiceProvider;
use LightSaml\Model\Protocol\Response;
use Symfony\Contracts\EventDispatcher\Event;

/**
 *  Event is dispatched after FinalizeAssertions and before response is signed.
 *
 *  Allows you to alter the entire response before it gets signed.
 *
 * @see FinalizeAssertionsEvent
 */
class FinalizeResponseEvent extends Event
{
    public function __construct(public readonly Response $assertion, public readonly ServiceProvider $svProvider)
    {
    }
}
