<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\IdpBundle\Service;

use Cyber\IdpBundle\Entity\ServiceProvider;

interface AssertionProviderInterface
{
    /**
     * @param ServiceProvider $serviceProvider the SP that is requesting SSO
     *
     * @return string unique id of the logged-in user, it should be an immutable property of the user
     */
    public function getUserNameId(ServiceProvider $serviceProvider): string;

    /**
     * @param ServiceProvider $serviceProvider the SP that is requesting SSO
     *
     * @return array<string, string|string[]> attributes name => values to be added to assertions
     */
    public function getUserAttributes(ServiceProvider $serviceProvider): array;
}
