<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

declare(strict_types=1);

namespace Cyber\IdpBundle\Service;

use Cyber\IdpBundle\Entity\ServiceProviderRepoInterface;
use SensitiveParameter;

class SamlConfig
{
    public function __construct(
        public readonly string $entityId,
        public readonly ServiceProviderRepoInterface $spRepo,
        public readonly string $certificate,
        #[SensitiveParameter]
        public readonly string $key,
    ) {
    }
}
