<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\IdpBundle\DependencyInjection;

use Cyber\IdpBundle\DependencyInjection\CyberIdpExtension;
use Cyber\IdpBundle\Service\AuthnRequestProcessor;
use Cyber\IdpBundle\Service\SsoInitiator;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\EventDispatcher\EventDispatcher;

/**
 * @internal
 *
 * @coversNothing
 */
class CyberIdpExtensionTest extends TestCase
{
    public function testEmptyLoad(): void
    {
        $extension   = new CyberIdpExtension();
        $container   = new ContainerBuilder();

        $extension->load([], $container);
        // assert stuff
        static::assertTrue(true);
    }

    public function testSomeConfigLoad(): void
    {
        $extension   = new CyberIdpExtension();
        $container   = new ContainerBuilder();

        $config = ['saml' => [
            'entity_id'             => 'abc',
            'sp_repository_service' => 'efg',
            'certificate'           => 'cert-data',
            'key'                   => 'key-data',
        ]];

        $extension->load([$config], $container);

        static::assertTrue(true); // if we got no exception we are good.
    }

    public function testCompile(): void
    {
        $extension    = new CyberIdpExtension();
        $container    = new ContainerBuilder();
        $container->register(MockSp::class);
        $container->register('event_dispatcher', EventDispatcher::class);

        $validConfigs = ['saml' => [
            'entity_id'             => 'abc',
            'sp_repository_service' => MockSp::class,
            'certificate'           => 'cert-data',
            'key'                   => 'key-data',
        ]];

        $extension->load([$validConfigs], $container);
        $container->getDefinition(AuthnRequestProcessor::class)->setPublic(true);
        $container->getDefinition(SsoInitiator::class)->setPublic(true);
        $container->compile();

        $processor = $container->get(AuthnRequestProcessor::class);
        $initiator = $container->get(SsoInitiator::class);

        // assert container has some service
        static::assertNotNull($processor);
        static::assertNotNull($initiator);
    }
}
