<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MenuBundle\Fixture;

class Configs
{
    /**
     * @param string $menuId
     *
     * @return array<mixed>
     */
    public static function getRawConfigs(string $menuId): array
    {
        return [
            $menuId => [
                'menu_name' => [
                    'caption' => 'my menu',
                    'routes'  => [
                        'menu_route' => ['ROLE_USER', 'ROLE_MENU'],
                    ],
                ],
            ],
        ];
    }

    /**
     * @param string $menuId
     *
     * @return array<mixed>
     */
    public static function getResolvedConfigs($menuId): array
    {
        return [
            $menuId => [
                'menu_name' => [
                    'caption' => 'my menu',
                    'routes'  => [
                        'menu_route' => ['ROLE_USER', 'ROLE_MENU'],
                    ],
                ],
            ],
        ];
    }
}
