<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MenuBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('cyber_menu');

        /** @var ArrayNodeDefinition $rootNode */
        $rootNode = $treeBuilder->getRootNode();

        //@formatter:off
        $rootNode
            ->useAttributeAsKey('name')
            ->prototype('array')
            ->prototype('array')
                ->children()
                    ->scalarNode('caption')
                        ->isRequired()
                        ->cannotBeEmpty()
                    ->end()
                    ->arrayNode('routes')
                        ->isRequired()
                        ->requiresAtLeastOneElement()
                        ->prototype('array')
                            ->prototype('scalar')->end()
                        ->end()
                    ->end()
                    ->variableNode('extra')->end()
                ->end()
            ->end();
        //@formatter:on
        return $treeBuilder;
    }
}
