<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MenuBundle\Service;

use Twig\Environment;
use Twig\Error\Error;

class MenuRenderer
{
    /** @var array<mixed> */
    private $menu;

    /**
     * @var Environment
     */
    private $twig;

    /**
     * @param Environment  $templating
     * @param array<mixed> $config
     */
    public function __construct($templating, $config)
    {
        $this->twig = $templating;
        $this->menu = $config;
    }

    /**
     * @throws Error if twig render error occurs
     *
     * @return string
     */
    public function render(): string
    {
        return $this->twig->render('CyberMenuBundle::menu.html.twig', ['items' => $this->menu]);
    }
}
