<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MenuBundle\Twig;

use Cyber\MenuBundle\Service\MenuRenderer;
use RuntimeException;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class MenuRendererExtension extends AbstractExtension
{
    /** @var ContainerInterface */
    private $container;

    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('cyber_menu', [$this, 'cyberMenuFunction'], ['is_safe' => ['html']]),
        ];
    }

    /**
     * @param string $menuName
     *
     * @throws \Twig\Error\Error
     *
     * @return string
     */
    public function cyberMenuFunction($menuName): string
    {
        if (!$this->container->has('cyber.menu.config.' . $menuName)) {
            throw new RuntimeException('Menu `' . $menuName . '` is not found !');
        }

        /** @var MenuRenderer $menuService */
        $menuService = $this->container->get('cyber.menu.config.' . $menuName);

        return $menuService->render();
    }

    public function getName(): string
    {
        return 'cyber_menu';
    }
}
