<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MenuBundle;

use Cyber\MenuBundle\CyberMenuBundle;
use Cyber\MenuBundle\DependencyInjection\CyberMenuExtension;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\ExtensionInterface;
use Tests\Cyber\MenuBundle\Fixture\Configs;

class DependencyInjectionTest extends WebTestCase
{
    public function testBundle(): ExtensionInterface
    {
        $bundle = new CyberMenuBundle();

        $extension = $bundle->getContainerExtension();

        $this->assertInstanceOf(CyberMenuExtension::class, $extension);

        return $extension;
    }

    /**
     * @depends testBundle
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function testExtension(CyberMenuExtension $extension): void
    {
        $container = new ContainerBuilder();

        $menuId = 'test';

        $extension->load([
            Configs::getRawConfigs($menuId),
        ], $container);

        $menuDef = Configs::getResolvedConfigs('test');

        //test for service and parameter definitions
        $serviceName = 'cyber.menu.config.' . $menuId;

        $this->assertTrue($container->hasDefinition($serviceName));

        $def = $container->getDefinition($serviceName);

        $arg1 = $def->getArgument(1);
        $this->assertArrayHasKey($menuId, $menuDef);
        $this->assertEquals($menuDef[$menuId], $arg1);
    }
}
