<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MenuBundle\Service;

use Cyber\MenuBundle\Service\MenuRenderer;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Tests\Cyber\MenuBundle\Fixture\Configs;
use Twig\Environment;

class MenuRendererTest extends WebTestCase
{
    /**
     * @var array<mixed>
     */
    private $items;

    /**
     * @SuppressWarnings(PHPMD.StaticAccess)
     */
    public function setUp(): void
    {
        $this->items = Configs::getResolvedConfigs('admin');
    }

    /**
     * @throws \Twig\Error\Error never
     */
    public function testService(): void
    {
        $templating = $this->getMockBuilder(Environment::class)
            ->disableOriginalConstructor()
            ->getMock();
        $templating->expects($this->once())
            ->method('render')
            ->willReturn('data');

        $class  = new MenuRenderer($templating, $this->items);
        $result = $class->render();

        $this->assertEquals('data', $result);
    }
}
