<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MenuBundle\Twig;

use Cyber\MenuBundle\Twig\MenuRendererExtension;
use PHPUnit\Framework\MockObject\MockObject;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class MenuRendererExtensionTest extends WebTestCase
{
    public function setUp(): void
    {
    }

    public function testExtension(): void
    {
        $menuRenderer = $this->getMockBuilder('Cyber\\MenuBundle\\Service\\MenuRenderer')
            ->disableOriginalConstructor()
            ->getMock();
        $menuRenderer->expects($this->once())
            ->method('render')
            ->willReturn('menu items');

        /** @var ContainerBuilder|MockObject $container */
        $container = $this->getMockBuilder(ContainerBuilder::class)
            ->disableOriginalConstructor()
            ->getMock();
        $container->expects($this->once())
            ->method('has')
            ->with('cyber.menu.config.test')
            ->willReturn('cyber.menu.config.test');
        $container->expects($this->once())
            ->method('get')
            ->with('cyber.menu.config.test')
            ->willReturn($menuRenderer);

        $menuRendererExt = new MenuRendererExtension($container);
        $this->assertContains('menu items', $menuRendererExt->cyberMenuFunction('test'));
        $this->assertEquals('cyber_menu', $menuRendererExt->getName());
        $this->assertArrayHasKey(0, $menuRendererExt->getFunctions());
        // @todo handle situation with exception return if service does not found
    }

    /**
     * @expectedException \RuntimeException
     */
    public function testExtensionWithException(): void
    {
        /** @var ContainerBuilder|MockObject $container */
        $container = $this->getMockBuilder(ContainerBuilder::class)
            ->disableOriginalConstructor()
            ->getMock();
        $container->expects($this->once())
            ->method('has')
            ->with('cyber.menu.config.test')
            ->willReturn(null);

        $menuRendererExt = new MenuRendererExtension($container);
        // this should throw exception
        $menuRendererExt->cyberMenuFunction('test');
    }
}
