This bundle provides a couple of tools and fixers to assist with project development.

## Pagination Subscriber
If you use KNP Pagination, you may have noticed your controller actions have lots of repeating code to achieve 
pagination. 

A typical flow is:
1. Build Query
2. Pass Query to Paginator
3. Return Paginator

By enabling this subscriber you can bypass steps 2 and 3, and simply return the Query or Query builder directly
from your action. 

```yaml
cyber_misc:
    paginator_response_listener: true
```

## Paginator Request Attribute
A special request attribute can be used to customize the behavior and default values of paginator during a particular 
request. The attribute name is in constant `Cyber\MiscBundle\Event\Subscriber\PaginationSubscriber::ATTRIBUTE` which
you should use instead of hard-coding the *string* name as it is subject to change.

This bundle uses the following pagination defaults:

```php
<?php 
    $defaults = [
        // used only if no page was specified in query
        'default_page'      => 1,
        // used only if no page size was specified in query
        'default_page_size' => 25,
        // if query specified page size less than this value, this value will be used
        'min_page_size'     => 10,
        // if query specified page size more than this value, this value will be used
        'max_page_size'     => 1000,
    ];
```

To override these defaults add the paginator attribute in your action like so:

```php
<?php

use Cyber\MiscBundle\Event\Subscriber\PaginationSubscriber;
use Symfony\Component\HttpFoundation\Request;

public function someAction(Request $request){
    $someData = [];
    $request->attributes->set(
        PaginationSubscriber::ATTRIBUTE, 
        [
            'default_page_size' => 50,
        ]
    );
    
    return $someData;
}
```

### Forcing Pagination
As you may be aware the `Paginator` component can actually paginate more things than just `Query` or `QueryBuilder`.
The paginator attribute can be used to force pagination in cases when your controller returns other supported values.
As long as the paginator attribute is set the paginator will execute. 

This simple snippet would cause the returned array to be paginated:

```php
<?php
use Cyber\MiscBundle\Event\Subscriber\PaginationSubscriber;
use Symfony\Component\HttpFoundation\Request;

public function someAction(Request $request){
    $someData = [];
    $request->attributes->set(PaginationSubscriber::ATTRIBUTE, []); // this forces paginator to execute
    
    return $someData;
}
```

> NOTE: since having paginator attribute causes pagination, you should be adding it at the end of your action. If you 
> add it at the beginning and an error occurs, the paginator may try to paginate the error response, which might not
> be what you are expecting or want to happen.
