<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\DependencyInjection\Compiler;

use Cyber\MiscBundle\Service\FosRestPathResolver;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class FosRestPathResolverPass implements CompilerPassInterface
{
    /**
     * {@inheritdoc}
     */
    public function process(ContainerBuilder $container): void
    {
        if (!$container->hasDefinition(FosRestPathResolver::class)) {
            // only register the ass if the service is enabled
            return;
        }
        $chainResolver = $container->getDefinition('fos_rest.versioning.chain_resolver');
        $chainResolver->addMethodCall('addResolver', [new Reference(FosRestPathResolver::class)]);
    }
}
