# Overview
Although amazon SES supports standard SMTP which will work with existing swift mailer transports, that approach has
certain drawbacks. Mainly, when sending mail, SES replaces the `Message-Id` header with its own, and there is no way
to know what it is via SMTP.

Transport in this bundle utilizes SES API to transmit the email, which allows to get said id via API response and update
the local `Swift_Message` object with proper id.

# Configuration
The configuration requires 2 steps:
1. enable the transport service via bundle configuration
2. tell swift mailer to use said transport

## Enable Transport
```yaml
cyber_misc:
    ses:
        key: '%env(AWS_KEY)%'
        secret: '%env(AWS_SECRET)%'
```

## Use Transport in Mailer
```yaml
swiftmailer:
    transport: Cyber\MiscBundle\Service\AwsSesMailerTransport
```

Now all you do is send your email like you normally would with `Swift_Mailer` service.
