<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MiscBundle\DependencyInjection;

use Cyber\MiscBundle\DependencyInjection\CyberMiscExtension;
use Cyber\MiscBundle\Service\AwsSesMailerTransport;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class CyberMiscExtensionTest extends TestCase
{
    public function testEmptyLoad(): void
    {
        $extension = new CyberMiscExtension();
        $container = new ContainerBuilder();

        $extension->load([[]], $container);

        $this->assertTrue(true); // if we got no exception we are good.
    }

    public function testSomeConfigLoad(): void
    {
        $extension = new CyberMiscExtension();
        $container = new ContainerBuilder();

        $config = [
            'paginator_response_listener' => true,
        ];

        $extension->load([$config], $container);
        // assert stuff

        $this->assertTrue(true);
    }

    /**
     * @expectedException \Symfony\Component\Config\Definition\Exception\InvalidConfigurationException
     * @expectedExceptionMessage cyber_misc.ses
     * @dataProvider             invalidConfigs
     *
     * @param mixed $sesConfig
     */
    public function testInvalidConfigLoad($sesConfig): void
    {
        $extension = new CyberMiscExtension();
        $container = new ContainerBuilder();

        $config = [
            'ses' => $sesConfig,
        ];

        $extension->load([$config], $container);
        // assert stuff

        $this->assertTrue(true);
    }

    /**
     * @return \Generator<array<mixed>>
     */
    public function invalidConfigs(): \Generator
    {
        yield [null];
        yield [[]];
        yield [['client' => 'a', 'key' => 'b']];
    }

    public function testCompile(): void
    {
        $extension    = new CyberMiscExtension();
        $container    = new ContainerBuilder();
        $validConfigs = [];

        $extension->load([$validConfigs], $container);
        $container->compile();

        // assert container has some service
        $this->assertTrue(true);
    }

    public function testCompileSes(): void
    {
        $extension    = new CyberMiscExtension();
        $container    = new ContainerBuilder();
        $validConfigs = ['ses' => ['key' => 'b', 'secret' => 'a']];

        $extension->load([$validConfigs], $container);
        $container->getDefinition(AwsSesMailerTransport::class)->setPublic(true);
        $container->compile();

        // assert container has some service
        $this->assertTrue($container->has(AwsSesMailerTransport::class));
    }
}
