<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Tests\Cyber\MiscBundle\Service;

use Aws\Ses\SesClient;
use Cyber\MiscBundle\Service\AwsSesMailerTransport;
use PHPUnit\Framework\TestCase;
use Swift_Message;

class AwsSesMailerTransportTest extends TestCase
{
    /**
     * @var \PHPUnit\Framework\MockObject\MockObject|SesClient
     */
    private $mockClient;

    /**
     * @var AwsSesMailerTransport
     */
    private $instance;

    protected function setUp(): void
    {
        $this->mockClient = $this->getMockBuilder(SesClient::class)->disableOriginalConstructor()->getMock();
        $this->instance   = new AwsSesMailerTransport($this->mockClient);
    }

    public function testIsStarted(): void
    {
        $this->assertTrue($this->instance->isStarted());
    }

    public function testPing(): void
    {
        $this->assertTrue($this->instance->ping());
    }

    public function testSend(): void
    {
        $this->mockClient->expects($this->once())
            ->method('__call')
            ->with('sendRawEmail')
            ->willReturn(['MessageId' => '5']);

        $message = new Swift_Message('Test', 'This is a test');
        $message
            ->setFrom('symfony.collection@cybercoder.site')
            ->setTo('vj-dev1@cybercoder.site')
            ->setBcc('vj-dev2@cybercoder.site');
        $sent = $this->instance->send($message);

        $this->assertEquals(2, $sent);
        $this->assertEquals('5@email.amazonses.com', $message->getId());
    }
}
