<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\Service;

use Aws\Ses\SesClient;
use Symfony\Component\Mailer\Transport\AbstractTransportFactory;
use Symfony\Component\Mailer\Transport\Dsn;
use Symfony\Component\Mailer\Transport\TransportInterface;

/**
 * @author Konstantin Myakshin <molodchick@gmail.com>
 * @author Jérémy Derussé <jeremy@derusse.com>
 */
final class SesTransportFactory extends AbstractTransportFactory
{
    public function create(Dsn $dsn): TransportInterface
    {
        $region = $dsn->getOption('region');

        $options = [
            'version'     => '2010-12-01',
            'region'      => $region ?: 'us-east-1',
            'credentials' => [
                'key'    => $dsn->getUser(),
                'secret' => $dsn->getPassword(),
                'token'  => $dsn->getOption('token'),
            ],
        ];
        if ('default' !== $dsn->getHost()) {
            $options['endpoint'] = 'https://' . $dsn->getHost() . ($dsn->getPort() ? ':' . $dsn->getPort() : '');
        }
        $client = new SesClient($options);

        return new AwsSesMailerTransport($client, $this->dispatcher, $this->logger);
    }

    /**
     * @return string[]
     */
    protected function getSupportedSchemes(): array
    {
        return ['aws+sdk'];
    }
}
