<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\FlatList;

interface NvpStorage
{
    /**
     * Write key value pair to storage.
     *
     * @param string $key
     * @param mixed  $value
     *
     * @return bool
     */
    public function write(string $key, $value): bool;

    /**
     * Read key value from storage.
     *
     * @param string $key
     *
     * @return mixed
     */
    public function read(string $key);

    /**
     * Delete key from storage.
     *
     * @param string $key
     *
     * @return mixed
     */
    public function delete(string $key);

    /**
     * Increment key by 1.
     *
     * This operation should be atomic.
     *
     * @param string $key
     *
     * @return false|int
     */
    public function increment(string $key);

    /**
     * Decrement key by 1.
     *
     * This operation should be atomic.
     *
     * @param string $key
     *
     * @return bool
     */
    public function decrement(string $key): bool;
}
