<?php

/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package.
 */

declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\Kafka;

use Generator;
use RdKafka\Message;

interface KafkaStreamerInterface
{
    /**
     * Add a function to be executed when there haven't been any messages for a specified idle time.
     *
     * @param callable $callback callable will be passed a single argument which is the instance of the streamer
     */
    public function addIdleCallback(callable $callback): void;

    /**
     * @param int $idleTimeSec if no messages received for this number of seconds, idle callbacks will be triggered
     *
     * @throws \RdKafka\Exception
     *
     * @return Generator<Message>
     */
    public function streamEvents(int $idleTimeSec = 0): Generator;

    /**
     * Calling this will cause the streaming event generator to stop after current iteration.
     *
     * The consumer will be closed.
     */
    public function stop(): void;
}
