<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\Kafka;

use LogicException;
use RdKafka\KafkaConsumer;
use RdKafka\KafkaConsumerTopic;

class SingleTopicConsumer extends KafkaConsumer
{
    /** @var KafkaConsumerTopic */
    private $topic;

    public function assignTopic(string $name): void
    {
        $topic = $this->newTopic($name);
        \assert($topic instanceof KafkaConsumerTopic);
        $this->topic = $topic;
    }

    public function storeOffset(int $partition, int $offset): void
    {
        $this->topic->offsetStore($partition, $offset);
    }

    /**
     * @inheritDoc
     */
    public function unsubscribe(): void
    {
        throw new LogicException('This consumer does not support unsubscribe.');
    }

    public function topicInfo(): KafkaConsumerTopic
    {
        return $this->topic;
    }
}
