<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\MiscBundle\Service;

use FOS\RestBundle\Version\VersionResolverInterface;
use Symfony\Component\HttpFoundation\Request;

class FosRestPathResolver implements VersionResolverInterface
{
    /**
     * @var string
     */
    private $regex;

    /**
     * If your version is in path like so /api/{version}/action the following regex could be used:
     * /^\/api\/(?P<version>v?[0-9\.]+)\//.
     *
     * @param string $regex regex containing a group which will result in matches containing 'version' key
     */
    public function __construct(string $regex)
    {
        $this->regex = $regex;
    }

    /**
     * @inheritdoc
     */
    public function resolve(Request $request): ?string
    {
        $path = $request->getPathInfo();

        if (false === \preg_match($this->regex, $path, $matches)) {
            return null;
        }

        return $matches['version'] ?? null;
    }
}
