At the time of creation Nelmio API Doc bundle does not properly handle the case where we want to pass a Model as param.
As is a typical case with symfony forms that get processed in GET request.

Example:

```php

#[OA\Parameter(
        name: 'my_form',
        in: 'query',
        schema: new OA\Schema(
            properties: [
                new OA\Property(property: 'my_form', ref: new Model(type: MyFormType::class)),
            ]
        )
    )]
function somAction() {

}
```

This bundle provides a processor to properly explode such models and generate OA compliant list of params.

# Config

To enable, add the following to your configs.

```yaml
cyber_misc:
    open_api_query_param_processor: true
```

# Simplified Definition

With this processor enabled, the definition is also simplified, as you can set the ref directly on the schema. Instead
of wrapping it in properties array.

```php

#[OA\Parameter(
    name: 'my_form',
    in: 'query',
    x: ['query-args-$ref' => true],
    schema: new OA\Schema(
        ref: new Model(type: MyFormType::class)
    )
)]
function somAction() {

}
```

> notice the `x: ['query-args-$ref' => true],` this is an activation trigger for the processor.
> without it the standard behavior will persist

## Form Types Without Block Prefix

If your form has empty block prefix set the param name to empty string:

```php

#[OA\Parameter(
    name: '',
    in: 'query',
    x: ['query-args-$ref' => true],
    schema: new OA\Schema(
        ref: new Model(type: MyNoPrefixType::class)
    )
)]
function somAction() {

}
```
