<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Event;

use Cyber\OrmExtras\Supplier\UserLoader;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

class CacheWarmer implements CacheWarmerInterface
{
    /** @var UserLoader */
    private $loader;

    public function __construct(UserLoader $loader)
    {
        $this->loader = $loader;
    }

    /**
     * {@inheritdoc}
     */
    public function isOptional(): bool
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function warmUp($cacheDir): void
    {
        try {
            $this->loader->load();
        } catch (\Exception $e) {
            \fwrite(
                STDERR,
                'An exception occurred during Cyber Orm Extras Cache Warmup. See stacktrace for details.' . PHP_EOL . PHP_EOL
                . \get_class($e) . ': ' . $e->getMessage() . PHP_EOL . PHP_EOL
                . $e->getTraceAsString() . PHP_EOL . PHP_EOL
            );
        }
    }
}
