Creator and Editor Attribute classes are here to help you quickly add tracking of the user and date when and by who 
any entity was created or last updated.

## Configuration

For this feature to work a proper [user supplier configuration](user-supplier.md) should be provided.

## Usage

To use the Creator and/or Editor Attributes, implement the corresponding interfaces in your entities.

> You can implement either Creator or Editor interfaces or BOTH

You may also want to use the provided traits to avoid having to repeatedly define same getters/setters.

In the example below both `CreatorAttributes` and `EditorAttributes` are used together with the corresponding traits

```php
<?php
use Cyber\OrmExtras\Utility\EditorAttributes;
use Cyber\OrmExtras\Utility\CreatorAttributes;
use Cyber\OrmExtras\Utility\EditorAttributeTrait;
use Cyber\OrmExtras\Utility\CreatorAttributeTrait;

class Beneficiary implements EditorAttributes, CreatorAttributes
{
    use EditorAttributeTrait, CreatorAttributeTrait;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="YourBundle\Entity\User")
     * @ORM\JoinColumn(name="bnf_usr_id_edited", referencedColumnName="usr_id", nullable=false)
     */
    protected $userEdited;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="bnf_date_edited", type="datetime", nullable=false)
     */
    protected $dateEdited;

    /**
     * @var User
     *
     * @ORM\ManyToOne(targetEntity="YourBundle\Entity\User")
     * @ORM\JoinColumn(name="bnf_usr_id_created", referencedColumnName="usr_id", nullable=false)
     */
    protected $userCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="bnf_date_created", type="datetime", nullable=false)
     */
    protected $dateCreated;
}
```

The field names and corresponding getters/setters are provided by the traits. The traits also satisfy requirements of
the corresponding interfaces. So the only thing you really have to do is provide the `ORM` mapping for the columns.
