<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use DateTime;

trait CreatorAttributeTrait
{
    /** @var mixed */
    protected $userCreated;

    /**
     * @var DateTime
     */
    protected $dateCreated;

    /**
     * Returns properties that should be updated in a cascade when this entity is created.
     *
     * @return CreatorAttributes[]
     */
    public function getCreatorCascade(): array
    {
        return [];
    }

    /**
     * returns the date of the creation.
     *
     * @return null|DateTime
     */
    public function getDateCreated(): ?DateTime
    {
        return $this->dateCreated;
    }

    /**
     * Sets the date of the creation.
     *
     * @param DateTime $date
     *
     * @return $this
     */
    public function setDateCreated(DateTime $date)
    {
        $this->dateCreated = $date;

        return $this;
    }

    /**
     * returns the user who created this entity.
     *
     * @return mixed
     */
    public function getUserCreated()
    {
        return $this->userCreated;
    }

    /**
     * Sets the user who created this entity.
     *
     * @param mixed $user the user that created this entity
     *
     * @return $this
     */
    public function setUserCreated($user)
    {
        $this->userCreated = $user;

        return $this;
    }
}
