<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Supplier;

class SupplierConfiguration
{
    /** @var class-string */
    public $userEntityClass;

    /** @var string */
    public $idField;

    /** @var string */
    public $defaultId;

    /**
     * SupplierConfiguration constructor.
     *
     * @param class-string $userEntityClass
     * @param string       $idField
     * @param string       $defaultId
     */
    public function __construct(string $userEntityClass, string $idField, string $defaultId)
    {
        $this->userEntityClass = $userEntityClass;
        $this->idField         = $idField;
        $this->defaultId       = $defaultId;
    }
}
