<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

interface SoftDeletable
{
    /**
     * @return null|mixed
     */
    public function getUserDeleted();

    /**
     * @param mixed $user the user who deleted the entity
     *
     * @return $this
     */
    public function setUserDeleted($user);

    /**
     * @return null|\DateTime
     */
    public function getDateDeleted(): ?\DateTime;

    /**
     * @param \DateTime $date date when deletion took place
     *
     * @return $this
     */
    public function setDateDeleted(\DateTime $date = null);

    /**
     * @return bool
     * @SuppressWarnings(PHPMD.BooleanGetMethodName)
     */
    public function getForceDelete(): bool;

    /**
     * @param bool $force
     *
     * @return $this
     */
    public function setForceDelete($force);
}
