<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

trait SoftDeletableTrait
{
    protected $userDeleted;

    protected $dateDeleted;

    protected $forceDelete = false;

    public function getUserDeleted()
    {
        return $this->userDeleted;
    }

    public function setUserDeleted($user)
    {
        $this->userDeleted = $user;

        return $this;
    }

    public function getDateDeleted(): ?\DateTime
    {
        return $this->dateDeleted;
    }

    public function setDateDeleted(\DateTime $date = null)
    {
        $this->dateDeleted = $date;

        return $this;
    }

    public function isDeleted(): bool
    {
        return null !== $this->dateDeleted;
    }

    public function getForceDelete(): bool
    {
        return $this->forceDelete;
    }

    public function setForceDelete($force)
    {
        $this->forceDelete = $force;

        return $this;
    }
}
