<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Annotations;

use Doctrine\Common\Annotations\Annotation;

/**
 * @Annotation
 *
 * @Target("CLASS")
 */
class TablePrefix extends Annotation
{
    /**
     * @inheritdoc
     */
    public function __set($name, $value): void
    {
        if ('prefix' === $name) {
            @\trigger_error('The "prefix" key for TablePrefix annotation is deprecated. Pass the prefix as the value @TablePrefix("your_prefix").', E_USER_DEPRECATED);
            $this->value = $value;

            return;
        }

        parent::__set($name, $value);
    }
}
