<?php declare(strict_types=1);
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use RuntimeException;

trait UuidEntityTrait
{
    /**
     * @var UuidInterface
     *
     * @ORM\Id
     * @ORM\Column(type="uuid")
     */
    protected UuidInterface $id;

    /**
     * Generates value for $id field.
     *
     * You must call this in the constructor of your entity.
     *
     * @param null|callable $callable a custom callable for uuid generation, intended for tests
     */
    private function generateId($callable = null): void
    {
        try {
            /** @var UuidInterface $uuid */
            $uuid     = \call_user_func($callable ?: [Uuid::class, 'uuid4']);
            $this->id = $uuid;
        } catch (\Exception $ex) {
            throw new RuntimeException('UUID generation failure, probably missing dependency.', 0, $ex);
        }
    }

    /**
     * @return UuidInterface the id of the entity
     */
    public function getId(): UuidInterface
    {
        return $this->id;
    }
}
