The `UuidEntityTrait` provides id generator and default constructor and mapping for Id field.

## Dependency
You must include the following dependencies in your composer file for this trait to work:
* ramsey/uuid
* ramsey/uuid-doctrine

## Configuration
The following configuration needs to be added to doctrine for proper uuid mapping
```yaml
doctrine:
    dbal:
        types:
            uuid_binary:  Ramsey\Uuid\Doctrine\UuidBinaryType
        mapping_types:
            uuid_binary: binary
```

## Usage

Simply `use` the trait in your entity. When you do, the `id` field will be defined and mapped using doctrine 
annotations.

The default constructor will generate the id which you can fetch using the provided `toId()` function.

### DB Lookup
The `UuidBinaryType` knows how to operate on various values and formats of UUID when performing database lookups.
For example if you execute `$repository->find($id)` to find your entity by id. The `$id` can be in any of these formats:
* instance of `UuidInterface`
* un-formatted hex string `6F77BAEAD3E911E9AD0B0242AC140002`
* GUID style string `5965C452-D401-11E9-BB65-2A2AE2DBCCE4`
* prefixed with `urn:uuid:`
* wrapped in braces `{uuid-here}`
* or combination of several from the above: `urn:uuid:{5965C452-D401-11E9-BB65-2A2AE2DBCCE4}`

### Id Presentation
The `UuidInterface` has two functions that you will typically use to send the ID to frontend `toString()` and `getHex()`.
The only difference between the 2 is that former includes dashes (-) while the latter is just a long string of hex numbers.

## Overriding
Sometimes you might need to override the constructor or the field itself. 

### Constructor
Since this is not a class you extend you will have to replicate the behavior of constructor in your code.
This can be done by simply adding the following line to the beginning of your constructor: `$this->generateId();`

### ID Field
If you are not satisfied with the column mapping of the id field you may override it in your entity. The
only requirement for UUID to work is that the `id` field has annotation `@ORM\Id` and that column type is
`uuid_binary` as defined in the configuration above. 
