<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Event;

use Cyber\OrmExtras\Supplier\UserLoader;
use Symfony\Component\HttpKernel\CacheWarmer\CacheWarmerInterface;

class CacheWarmer implements CacheWarmerInterface
{
    /** @var UserLoader */
    private $loader;

    public function __construct(UserLoader $loader)
    {
        $this->loader = $loader;
    }

    /**
     * @inheritdoc
     */
    public function isOptional(): bool
    {
        return true;
    }

    /**
     * @inheritdoc
     */
    public function warmUp(string $cacheDir): array
    {
        try {
            $this->loader->load();
        } catch (\Throwable $e) {
            // do not throw or log any errors from here, in many cases this might run during initial install
            // or in CI without DB which causes confusion if error is logged during warmup process.
            // since this is optional anyway let user deal with fallout at runtime.
        }

        return [];
    }
}
