<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

interface EditorAttributes
{
    /**
     * Returns properties that should be updated in a cascade when this entity is updated.
     *
     * @return EditorAttributes[]
     */
    public function getEditorCascade(): array;

    /**
     * returns the user who last edited this entity.
     *
     * @return null|mixed the user that last edited this entity
     */
    public function getUserEdited();

    /**
     * sets the user who last edited this entity.
     *
     * @param mixed $user the user that last edited this entity
     *
     * @return $this
     */
    public function setUserEdited($user);

    /**
     * returns the date of last edit.
     *
     * @return null|\DateTime
     */
    public function getDateEdited(): ?\DateTimeInterface;

    /**
     * sets the date of last edit.
     *
     * @param \DateTimeInterface $date
     *
     * @return $this
     */
    public function setDateEdited(\DateTimeInterface $date);
}
