The `TypeFunction` allows to gain access to the value of a discriminatory column of entities with inheritance map 
from within DQL queries.

## Configuration
To enable this function add the following to your configuration:

```yml
# Doctrine Configuration
doctrine:
    orm:
        dql:
            string_functions:
                type: Cyber\OrmExtras\Functions\TypeFunction
```

> The key **type** in the above configuration will actually be the function name you will have to use in DQL.
>
> You can actually call the function anyway you want, but for purposes of this example it will be **type**


## Use Cases
By default doctrine does not allow to access value of discriminatory column. Although we can still filter by it using 
`INSTANCE OF` construct, it is currently not possible to do the following:

* Order results by discriminatory column
* Fetch the Type of entities through DQL

And that is exactly what the `TypeFunction` aims to solve.

## Sample Usage

The below example will be based on the above configuration and the `Person` entity from Doctrine's documentation on
[Inheritance Mapping][doctrine-mapping-doc], which has a discriminator field named **discr**.

### Selecting type value
Let's take the following DQL:
```sql
SELECT TYPE(p) FROM Person p;
```
Doctrine would convert it to:

```sql
SELECT p.discr FROM person_table p;
```

### Ordering by type

The following will select all `Person` entities ordered by their discriminatory column (aka type)
```sql
SELECT p, TYPE(p) AS HIDDEN prs_type FROM Person p ORDER BY flf_type DESC
```

> Note how in this example we marked **prs_type** as *HIDDEN*. That is important if we want to receive a simply array of
> hydrated `Person` objects. Not marking it as hidden will return an array of 2 elements for each `Person` entity (first
> element being the hydrated `Person` entity and the second the value of prs_type)

[doctrine-mapping-doc]: http://docs.doctrine-project.org/projects/doctrine-orm/en/latest/reference/inheritance-mapping.html#single-table-inheritance
