<?php
/**
 * This file is subject to the terms and conditions defined in file 'LICENSE', which is part of this source code
 * package. If the file is missing a copy can be found at:
 * https://gitlab.cybercoder.site/vj/policies-procedures-standards/blob/master/licensing/CYBER-LICENSE.
 */

namespace Cyber\OrmExtras\Utility;

use DateTime;

trait EditorAttributeTrait
{
    /** @var mixed */
    protected $userEdited;

    /**
     * @var DateTime
     */
    protected $dateEdited;

    /**
     * Returns properties that should be updated in a cascade when this entity is updated.
     *
     * @return EditorAttributes[]
     */
    public function getEditorCascade(): array
    {
        return [];
    }

    /**
     * returns the date of last edit.
     *
     * @return null|\DateTimeInterface
     */
    public function getDateEdited(): ?\DateTimeInterface
    {
        return $this->dateEdited;
    }

    /**
     * Sets the date of last edit.
     *
     * @param \DateTimeInterface $date
     *
     * @return $this
     */
    public function setDateEdited(\DateTimeInterface $date)
    {
        $this->dateEdited = $date;

        return $this;
    }

    /**
     * returns the user who last edited this entity.
     *
     * @return null|mixed the user that last edited this entity
     */
    public function getUserEdited()
    {
        return $this->userEdited;
    }

    /**
     * Sets the user who last edited this entity.
     *
     * @param mixed $user the user that last edited this entity
     *
     * @return $this
     */
    public function setUserEdited($user)
    {
        $this->userEdited = $user;

        return $this;
    }
}
